<?php
	/**
	 * Welcome Page Initiation
	*/

	get_template_part('/inc/welcome/welcome');

	/** Plugins **/
	$plugins_args = array(
		// *** Companion Plugins
		'companion_plugins' => array(

		),

		//Displays on Required Plugins tab
		'req_plugins' => array(

			// Free Plugins
			'free_plug' => array(
				'contact-form-7' => array(
					'slug' => 'contact-form-7',
					'filename' => 'wp-contact-form-7.php',
					'class' => 'WPCF7'
				),
				'accesspress-custom-post-type' => array(
					'slug' => 'accesspress-custom-post-type',
					'filename' => 'accesspress-cpt.php',
					'class' => 'CPT_Class'
				),
				'newsletter' => array(
					'slug' => 'newsletter',
					'filename' => 'plugin.php',
					'class' => 'Newsletter'
				)
			),
			'pro_plug' => array(

			),
		),

		// *** Displays on Import Demo section
		'required_plugins' => array(
			'access-demo-importer' => array(
					'slug' 		=> 'access-demo-importer',
					'name' 		=> esc_html__('Access Demo Importer', 'the-monday'),
					'filename' 	=>'access-demo-importer.php',
					'host_type' => 'wordpress', // Use either bundled, remote, wordpress
					'class' 	=> 'Access_Demo_Importer',
					'info' 		=> esc_html__('Access Demo Importer adds the feature to Import the Demo Conent with a single click.', 'the-monday'),
			),
		

		),

		
	);

	$strings = array(
		// Welcome Page General Texts
		'welcome_menu_text' => esc_html__( 'The Monday', 'the-monday' ),
		'theme_short_description' => esc_html__( 'The Monday- is an elegant responsive WordPress theme for any type of business or freelancers. It is feature-rich, multi-purpose and powerful WordPress theme with a beautiful and user-friendly design. It offers a complete customization capability and multiple options for building a website instantly. It features customizer tool, homepage options, multiple header and footer styles, archive and blog  page options, complete color and typography settings etc.', 'the-monday' ),

		// Plugin Action Texts
		'install_n_activate' 	=> esc_html__('Install and Activate', 'the-monday'),
		'deactivate' 			=> esc_html__('Deactivate', 'the-monday'),
		'activate' 				=> esc_html__('Activate', 'the-monday'),

		// Getting Started Section
		'doc_heading' 		=> esc_html__('Step 1 - Documentation', 'the-monday'),
		'doc_description' 	=> esc_html__('Read the Documentation and follow the instructions to manage the site , it helps you to set up the theme more easily and quickly. The Documentation is very easy with its pictorial  and well managed listed instructions. ', 'the-monday'),
		'doc_link'			=> 'https://doc.accesspressthemes.com/the-monday-doc/',
		'doc_read_now' 		=> esc_html__( 'Read Now', 'the-monday' ),
		'cus_heading' 		=> esc_html__('Step 2 - Customizer Panel', 'the-monday'),
		'cus_read_now' 		=> esc_html__( 'Go to Customizer Panels', 'the-monday' ),

		// Recommended Plugins Section
		'pro_plugin_title' 			=> esc_html__( 'Premium Plugins', 'the-monday' ),
		'free_plugin_title' 		=> esc_html__( 'Free Plugins', 'the-monday' ),

		

		// Demo Actions
		'activate_btn' 		=> esc_html__('Activate', 'the-monday'),
		'installed_btn' 	=> esc_html__('Activated', 'the-monday'),
		'demo_installing' 	=> esc_html__('Installing Demo', 'the-monday'),
		'demo_installed' 	=> esc_html__('Demo Installed', 'the-monday'),
		'demo_confirm' 		=> esc_html__('Are you sure to import demo content ?', 'the-monday'),

		// Actions Required
		'req_plugin_info' => esc_html__('All these required plugins will be installed and activated while importing demo. Or you can choose to install and activate them manually. If you\'re not importing any of the demos, you must install and activate these plugins manually.', 'the-monday' ),
		'req_plugins_installed' => esc_html__( 'All Recommended action has been successfully completed.', 'the-monday' ),
		'customize_theme_btn' 	=> esc_html__( 'Customize Theme', 'the-monday' ),
		'pro_plugin_title' 			=> esc_html__( 'Premium Plugins', 'the-monday' ),
		'free_plugin_title' 		=> esc_html__( 'Free Plugins', 'the-monday' ),
	);

	/**
	 * Initiating Welcome Page
	*/
	$my_theme_wc_page = new The_Monday_Welcome( $plugins_args, $strings );