<?php
/**
 * @package AccessPress Ray
 */
?>
<?php
global $accesspress_ray_options;
$accesspress_ray_settings = get_option( 'accesspress_ray_options', $accesspress_ray_options );
$cat_blog = $accesspress_ray_settings['blog_cat'];
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>
            
		<?php 
		if(has_category( $cat_blog) && !empty($cat_blog)){?>
			<div class="entry-meta">
				<?php accesspress_ray_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php }?>
	</header><!-- .entry-header -->


	<div class="entry-content">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'accesspress-ray' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
	<?php if(has_category( $cat_blog) && !empty($cat_blog)){

			/* translators: used between list items, there is a space after the comma */
			$category_list = get_the_category_list( __( ', ', 'accesspress-ray' ) );

			/* translators: used between list items, there is a space after the comma */
			$tag_list = get_the_tag_list( '', __( ', ', 'accesspress-ray' ) );

			if ( ! accesspress_ray_categorized_blog() ) {
				// This blog only has 1 category so we just need to worry about tags in the meta text
				if ( '' != $tag_list ) {
					/* translators: %3$s : permalink */
					$meta_text = __( 'This entry was tagged %2$s. Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'accesspress-ray' );
				} else {
					/* translators: %3$s : permalink */
					$meta_text = __( 'Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'accesspress-ray' );
				}

			} else {
				// But this blog has loads of categories so we should probably display them here
				if ( '' != $tag_list ) {
					/* translators: %2$s : permalink */
					$meta_text = __( 'This entry was posted in %1$s and tagged %2$s. Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'accesspress-ray' );
				} else {
					/* translators: %1$s : permalink */
					$meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'accesspress-ray' );
				}

			} // end check for categories on this blog
			printf(
				wp_kses_post($meta_text),
				wp_kses_post($category_list),
				wp_kses_post($tag_list),
				esc_url(get_permalink())
			);
		?>
	<?php } ?>
		<?php edit_post_link( __( 'Edit', 'accesspress-ray' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
